function fwslider(){
    var glob = {
        cs : 0,
        pause: 6000,
        duration: 750,
	mID: 1
    }
    
    this.init = function(params){
        
        if (params.duration) {
            glob.duration = parseInt(params.duration,10);
        }
        
        if (params.pause) {
            glob.pause = parseInt(params.pause,10);
        }
		 if (params.mID) {
            glob.mID = parseInt(params.mID,10);
        }
        
        /* Init */
        content.init();
        display.bindControls();
        controls.bindControls();
		
    }
    
    var display = {
        /* Resize function */
        resize: function(){
			
            jQuery("#fwslider" + glob.mID).css({height: jQuery("#fwslider" + glob.mID + " .slide").height()});
            controls.position();
        },
        
        /* Bind resize listener */
        bindControls: function(){
            jQuery(window).resize(function(){
                display.resize()
            });
        }
    }
    
    var controls = {
        /* Adjust buttons position */
		
        position: function(){
            jQuery("#fwslider" + glob.mID + " .slidePrev, #fwslider" + glob.mID + " .slideNext").css({
                top: jQuery("#fwslider" + glob.mID + "").height() / 2 - jQuery("#fwslider" + glob.mID + " .slideNext").height() / 2
            });
            
             jQuery("#fwslider" + glob.mID + " .slidePrev").css({opacity:.5});
            jQuery("#fwslider" + glob.mID + " .slideNext").css({opacity:.5});
           
			
        },
        
        /* Bind button controls */
        bindControls : function(){
            
            /* Hover effect */
            jQuery("#fwslider" + glob.mID + " .slidePrev, #fwslider" + glob.mID + " .slideNext").on("mouseover", function(){
                jQuery(this).animate({
                    opacity:1
                },{
                    queue:false, 
                    duration:1000,
                    easing:"easeOutCubic"
                });
            });
            
            /* Hover effect - mouseout */
            jQuery("#fwslider" + glob.mID + " .slidePrev, #fwslider" + glob.mID + " .slideNext").on("mouseout", function(){
                jQuery(this).animate({
                    opacity:0.5
                },{
                    queue:false, 
                    duration:1000,
                    easing:"easeOutCubic"
                });
            });
            
            /* Next Button */
            jQuery("#fwslider" + glob.mID + " .slideNext").on("click", function(){
                if (jQuery("#fwslider" + glob.mID + " .slide").is(":animated")) return; 
                
                if (jQuery("#fwslider" + glob.mID + " .slide:eq("+(glob.cs+1)+")").length <= 0) {
                    glob.cs = 0;
                    
                    jQuery("#fwslider" + glob.mID + " .timers .timer .progress").stop();
                    
                    jQuery("#fwslider" + glob.mID + " .timers .timer:last .progress").animate({
                        width:"100%"
                    },{
                        queue:false,
                        duration:glob.duration,
                        easing:"easeOutCubic",
                        complete: function(){
                            jQuery("#fwslider" + glob.mID + " .timers .timer .progress").css({
                                width:"0%"
                            });
                        }
                    });
                } else {
                    glob.cs++;
                    
                    jQuery("#fwslider" + glob.mID + " .timers .timer .progress").stop();
                    jQuery("#fwslider" + glob.mID + " .timers .timer:lt("+glob.cs+") .progress").animate({
                        width:"100%"
                    },{
                        queue:false,
                        duration:glob.duration,
                        easing:"easeOutCubic"
                    });
                    
                }
                content.show();
            });
            
            /* Previous Button */
            jQuery("#fwslider" + glob.mID + " .slidePrev").on("click", function(){
                if (jQuery("#fwslider" + glob.mID + " .slide").is(":animated")) return; 
                
                if (glob.cs <= 0) {
                    glob.cs = jQuery("#fwslider" + glob.mID + " .slide").index();
                    
                    jQuery("#fwslider" + glob.mID + " .timers .timer .progress").stop();
                    jQuery("#fwslider" + glob.mID + " .timers .timer .progress").css({
                        width:"100%"
                    });
                     jQuery("#fwslider" + glob.mID + " .timers .timer:last .progress").animate({
                        width:"0%"
                    },{
                        queue:false,
                        duration:glob.duration,
                        easing:"easeOutCubic"
                    });
                    
                } else {
                    glob.cs--;
                    
                    jQuery("#fwslider" + glob.mID + " .timers .timer .progress").stop();
                    jQuery("#fwslider" + glob.mID + " .timers .timer:gt("+glob.cs+") .progress").css({
                        width:"0%"
                    });
                    jQuery("#fwslider" + glob.mID + " .timers .timer:eq("+glob.cs+") .progress").animate({
                        width:"0%"
                    },{
                        queue:false,
                        duration:glob.duration,
                        easing:"easeOutCubic"
                    });
                }
                content.show();
            });
        }
    }
    
    var content = {
        init: function(){
            /* First run content adjustment */
            
            for (var i = 0; i < jQuery("#fwslider" + glob.mID + " .slide").length; i++){
                jQuery('<div class="timer"><div class="progress"></div></div>').appendTo("#fwslider" + glob.mID + " .timers");
            }
            
            jQuery("#fwslider" + glob.mID + " .timers").css({
                width: (jQuery("#fwslider" + glob.mID + " .timers .timer").length + 1) * 55
            });
            
            jQuery("#fwslider" + glob.mID + " .slide:eq("+glob.cs+")").fadeIn({
                duration:500, 
                easing: "swing"
            });
            
            jQuery("#fwslider" + glob.mID + "").animate({
                height: jQuery("#fwslider" + glob.mID + " .slide:first img").height()
            },{
                queue:false,
                duration:500, 
                easing: "easeInQuad", 
                complete: function(){
                    jQuery("#fwslider" + glob.mID + " .slidePrev").animate({
                        left:0
                    },{
                        queue:false,
                        duration:1000, 
                        easing:"easeOutCubic"
                    });
                    
                    jQuery("#fwslider" + glob.mID + " .slideNext").animate({
                        right:0
                    },{
                        queue:false,
                        duration:1000, 
                        easing:"easeOutCubic"
                    });
                    
                    content.showText();
                    controls.position();
                    display.resize();
                    auto.run();
                    auto.focus();
                }
            });
        },
        
        show: function(){
            /* Show slide */
            
            content.hideText();
            
            jQuery("#fwslider" + glob.mID + " .slide:eq("+glob.cs+")").css({
                opacity:0,
                zIndex:2
            }).show().animate({
                opacity:1
            },{
                queue:false,
                duration: glob.duration, 
                easing: "swing", 
                complete: function(){
                    jQuery("#fwslider" + glob.mID + " .slide:lt("+glob.cs+"), #fwslider" + glob.mID + " .slide:gt("+glob.cs+")").css({
                        zIndex:0
                    }).hide();
                   
                    jQuery("#fwslider" + glob.mID + " .slide:eq("+glob.cs+")").css({
                        zIndex:1
                    });
                    content.showText();
                    auto.run();
                }
            });
        },
        
        showText: function(){
            /* Show slide text */
            
             jQuery("#fwslider" + glob.mID + " .slide:eq("+glob.cs+") .title").animate({
                opacity:1
            },{
                queue:false,
                duration:300,
                easing:"swing"
            });
            
            setTimeout(function(){
                jQuery("#fwslider" + glob.mID + " .slide:eq("+glob.cs+") .description").animate({
                    opacity:1
                },{
                    queue:false,
                    duration:300,
                    easing:"swing"
                });
            },150)
            
            setTimeout(function(){
                jQuery("#fwslider" + glob.mID + " .slide:eq("+glob.cs+") .readmore").animate({
                    opacity:1
                },{
                    queue:false,
                    duration:300,
                    easing:"swing"
                });
            },300)
            
            
        },
        hideText: function(){
            /* Hide slide text */
            
            jQuery("#fwslider" + glob.mID + " .slide .title").animate({
                opacity:0
            },{
                queue:false,
                duration:300,
                easing:"swing"
            });
            
            setTimeout(function(){
                jQuery("#fwslider" + glob.mID + " .slide .description").animate({
                    opacity:0
                },{
                    queue:false,
                    duration:300,
                    easing:"swing"
                });
            },150)
            
            setTimeout(function(){
                jQuery("#fwslider" + glob.mID + " .slide .readmore").animate({
                    opacity:0
                },{
                    queue:false,
                    duration:300,
                    easing:"swing"
                });
            },300)
            
            
        }
    }
    
    var auto = {
        /* Run timer */
        run: function(){
            jQuery("#fwslider" + glob.mID + " .timer:eq("+glob.cs+") .progress").animate({
                width:"100%" 
            },{
                queue:false,
                duration: (glob.pause - (glob.pause/100)*(((jQuery("#fwslider" + glob.mID + " .timer:eq("+glob.cs+") .progress").width() / jQuery("#fwslider" + glob.mID + " .timer:eq("+glob.cs+")").width()) * 100))), 
                easing:"linear", 
                complete: function(){
                    jQuery("#fwslider" + glob.mID + " .slideNext").trigger("click");
                }
            });
        },
        
        /* Stop on focus */
        focus: function(){
            jQuery("#fwslider" + glob.mID + " .slide_content").on("mouseover", function(){
                if (jQuery("#fwslider" + glob.mID + " .slide").is(":animated")) return;
                jQuery("#fwslider" + glob.mID + " .timer .progress").stop();
            });
            
            jQuery("#fwslider" + glob.mID + " .slide_content").on("mouseleave", function(){
                if (jQuery("#fwslider" + glob.mID + " .slide").is(":animated")) return;
                auto.run();
            });
        }
    }
}